
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_DonationType : BaseTest 
	{

		private DataTable _dtDonationType;
		

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtDonationType = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM DonationType", true);

				this.RefreshData = false;
			}

		}


		[Test]
		public void GetDonationTypeLookupList_Pass()
		{
			DataTable dtTest = DAL.DonationType.GetDonationTypeLookupList();

			Assert.AreEqual(this._dtDonationType.Rows.Count, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeId), TABLES.DonationType.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDonationTypeLookupList_Fail()
		{
		}

		[Test]
		public void GetDonationTypeByID_Pass()
		{
			int donationId = System.Convert.ToInt32(this._dtDonationType.Rows[0][TABLES.DonationType.DonationTypeId]);

			DataRow drTest = DAL.DonationType.GetDonationTypeByID(donationId);

			Assert.AreEqual(4, drTest.Table.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.DonationType.DonationTypeId), TABLES.DonationType.DonationTypeId);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(ARTIFICIAL.DirectedType), ARTIFICIAL.DirectedType);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void GetDonationTypeByID_Fail()
		{
			DataRow drTest = DAL.DonationType.GetDonationTypeByID(0);
		}

		[Test]
		public void GetDonationTypeByCode_Pass()
		{
			char donationCode = System.Convert.ToChar(this._dtDonationType.Rows[0][TABLES.DonationType.DonationTypeCode]);
			
			DataRow drTest = DonationType.GetDonationTypeByCode(donationCode);

			Assert.AreEqual(3, drTest.Table.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.DonationType.DonationTypeId), TABLES.DonationType.DonationTypeId);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, drTest.Table.Columns.Contains(TABLES.DonationType.DonationTypeCode), TABLES.DonationType.DonationTypeCode);
		}

		[Test]
        [ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void GetDonationTypeByCode_Fail()
		{
			DataRow drTest = DAL.DonationType.GetDonationTypeByCode(char.MaxValue);
		}


	}
}
#endif
